#include <cstring>
#include <cstdio>
#include <bits/stdc++.h>
using namespace std;

const int mxN = 5005;
int trie[mxN * 30][2];
int cnt[mxN * 30];

int root = 0;
int sledeci = 0;

void insert(int x) {
    int tren = root;
    ++cnt[tren];
    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;

        if(trie[tren][vred] == -1) {
            trie[tren][vred] = ++sledeci;
        }

        tren = trie[tren][vred];
        ++cnt[tren];
    }
}

void erase(int x) {
    int tren = root;
    --cnt[tren];
    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;

        if(trie[tren][vred] == -1) {
            break;
        }

        tren = trie[tren][vred];
        --cnt[tren];
    }
}

int find(int x) {
    int ans = 0;

    int tren = root;

    for(int i = 29; i >= 0; --i) {
        int vred = (x >> i) & 1;

        if(trie[tren][vred ^ 1] != -1 && cnt[trie[tren][vred ^ 1]] > 0) {
            ans ^= (1 << i);
            tren = trie[tren][vred ^ 1];
        } else {
            tren = trie[tren][vred];
        }
    }

    return ans;
}

void Resi(int N, int *A, int Q, int *T, int *I, int *X, bool *O) {
    for(int i = 0; i < mxN * 30; ++i) {
        trie[i][0] = trie[i][1] = -1;
    }

    for(int i = 1; i <= Q; ++i) {
        if(T[i] == 1) {
            A[I[i]] = X[i];
            continue;
        }

        int l = I[i];
        int r = l + X[i] - 1;

//        cerr << "Ide A: ";
//        for(int j = l; j <= r; ++j) {
//            cerr << A[j] << " ";
//        }
//        cerr << endl;

        for(int j = l; j <= r; ++j) {
            insert(A[j]);
        }

        int prefiks = *min_element(A + l, A + r + 1);
        erase(prefiks);

        vector<int> nz;
        nz.push_back(prefiks);

        for(int j = l + 1; j <= r; ++j) {
            int vred = find(prefiks);
            erase(vred ^ prefiks);
            prefiks = vred;
            nz.push_back(vred);
        }

//        cerr << "Ide nz: ";
//        for(auto z : nz) cerr << z << " ";
//        cerr << endl;

        O[i] = is_sorted(nz.begin(), nz.end());
    }
}